# Fair E Web Host Billing Panel - Help Documentation

## Table of Contents

1. [Getting Started](#getting-started)
2. [User Management](#user-management)
3. [Client Portal](#client-portal)
4. [Admin Panel](#admin-panel)
5. [Services Management](#services-management)
6. [Billing & Invoices](#billing--invoices)
7. [Support System](#support-system)
8. [Analytics & Tracking](#analytics--tracking)
9. [API Documentation](#api-documentation)
10. [Troubleshooting](#troubleshooting)

---

## Getting Started

### First Login

1. Navigate to `https://billing.fairewebhost.ca`
2. Enter your email and password
3. Click "Sign In"

**Alternative:** Click "Sign in with Google" for OAuth authentication

### Creating an Account

1. Click "Create Account" on login page
2. Fill in all required fields:
   - Personal Information (Name, Email, Phone)
   - Address Information (Address, City, State, ZIP, Country)
   - Password (minimum 8 characters)
3. Accept Terms of Service
4. Click "Create Account"
5. Check your email for welcome message

### Password Reset

1. Click "Forgot Password?" on login page
2. Enter your email address
3. Check email for reset link
4. Click link and enter new password
5. Login with new password

---

## User Management

### User Roles

**Admin:**
- Full system access
- Manage all customers
- Configure system settings
- View all reports
- Manage servers and services

**Client:**
- Access own services
- View and pay invoices
- Submit support tickets
- Manage account settings

### Account Settings

**To update your profile:**
1. Login to your account
2. Click on your name (top right)
3. Select "Account Settings"
4. Update information
5. Click "Save Changes"

**To change password:**
1. Go to Account Settings
2. Click "Change Password"
3. Enter current password
4. Enter new password (twice)
5. Click "Update Password"

---

## Client Portal

### Dashboard Overview

The client dashboard shows:
- Active services summary
- Unpaid invoices
- Recent support tickets
- System announcements
- Quick actions

### Managing Services

**View Services:**
1. Click "Services" in menu
2. See list of all your hosting accounts
3. Click service to view details

**Service Details Include:**
- Domain name
- Package information
- Billing cycle
- Next due date
- Control panel access
- Resource usage

**Access cPanel:**
1. Go to Services
2. Click on service
3. Click "Login to cPanel"
4. Automatic single sign-on

### Domain Management

**View Domains:**
1. Click "Domains" in menu
2. See all registered domains
3. View expiry dates
4. Manage nameservers

**Update Nameservers:**
1. Go to Domains
2. Click domain name
3. Click "Manage Nameservers"
4. Enter new nameservers
5. Click "Update"

**Domain Renewal:**
1. Go to Domains
2. Click domain name
3. Click "Renew Domain"
4. Select renewal period
5. Complete payment

---

## Admin Panel

### Admin Dashboard

Access: `https://billing.fairewebhost.ca/admin/dashboard`

**Dashboard Metrics:**
- Total customers
- Active services
- Pending orders
- Monthly revenue
- Unpaid invoices
- Server status

### Customer Management

**View All Customers:**
1. Admin Panel → Customers
2. Search/filter customers
3. Click customer to view details

**Add New Customer:**
1. Admin Panel → Customers
2. Click "Add Customer"
3. Fill in customer information
4. Click "Create Customer"

**Edit Customer:**
1. Find customer
2. Click "Edit"
3. Update information
4. Click "Save Changes"

**Customer Actions:**
- View services
- View invoices
- View tickets
- Login as customer
- Suspend account
- Delete account

### Order Management

**View Orders:**
1. Admin Panel → Orders
2. Filter by status (Pending, Processing, Completed)
3. Click order to view details

**Process Order:**
1. Open order
2. Review details
3. Click "Approve" or "Reject"
4. Order is automatically provisioned if approved

### Service Management

**View All Services:**
1. Admin Panel → Services
2. Filter by status
3. Click service for details

**Service Actions:**
- Suspend service
- Unsuspend service
- Terminate service
- Change package
- Update billing cycle

**Create Manual Service:**
1. Admin Panel → Services
2. Click "Create Service"
3. Select customer
4. Choose package
5. Enter domain
6. Click "Create"

### Invoice Management

**Create Invoice:**
1. Admin Panel → Invoices
2. Click "Create Invoice"
3. Select customer
4. Add line items
5. Set due date
6. Click "Generate Invoice"

**Mark Invoice as Paid:**
1. Find invoice
2. Click "Mark as Paid"
3. Enter payment details
4. Click "Confirm"

### Server Management

**Add Server:**
1. Admin Panel → Servers
2. Click "Add Server"
3. Enter server details:
   - Name
   - Hostname
   - IP Address
   - Type (Shared/VPS/Dedicated)
   - Max accounts
4. Click "Add Server"

**Monitor Servers:**
- View current load
- Check account count
- Monitor status
- View server logs

### System Settings

**General Settings:**
1. Admin Panel → Settings
2. Update company information
3. Configure email settings
4. Set currency and tax rates
5. Click "Save Settings"

**Payment Gateway Settings:**
- Configure PayPal
- Configure Stripe
- Set payment methods
- Configure webhooks

**Email Templates:**
- Welcome email
- Invoice email
- Password reset
- Service suspension
- Custom templates

---

## Services Management

### Hosting Packages

**Package Features:**
- Disk space
- Bandwidth
- Email accounts
- Databases
- Subdomains
- Addon domains
- SSL certificates

**Billing Cycles:**
- Monthly
- Quarterly (3 months)
- Semi-annually (6 months)
- Annually (12 months)

### Service Status

**Active:** Service is running normally
**Suspended:** Service temporarily disabled (usually due to non-payment)
**Terminated:** Service permanently removed
**Pending:** Service awaiting provisioning

---

## Billing & Invoices

### Viewing Invoices

**Client View:**
1. Client Portal → Invoices
2. See all invoices
3. Filter by status (Paid/Unpaid)
4. Click invoice to view details

**Invoice Details:**
- Invoice number
- Issue date
- Due date
- Line items
- Subtotal, tax, total
- Payment status

### Paying Invoices

**Payment Methods:**
- PayPal
- Credit/Debit Card (Stripe)
- Bank Transfer

**To Pay Invoice:**
1. Open invoice
2. Click "Pay Now"
3. Select payment method
4. Complete payment
5. Receive confirmation email

### Payment History

View all transactions:
1. Client Portal → Billing
2. Click "Payment History"
3. See all completed payments
4. Download receipts

---

## Support System

### Creating Support Ticket

1. Client Portal → Support
2. Click "Open New Ticket"
3. Enter subject
4. Select department
5. Set priority
6. Describe issue
7. Attach files (optional)
8. Click "Submit Ticket"

### Ticket Priorities

- **Low:** General questions
- **Medium:** Non-urgent issues
- **High:** Service affecting issues
- **Urgent:** Critical problems

### Replying to Tickets

1. Go to Support
2. Click ticket
3. Type reply
4. Attach files if needed
5. Click "Send Reply"

### Ticket Status

- **Open:** New ticket
- **In Progress:** Being worked on
- **Waiting:** Awaiting your response
- **Closed:** Issue resolved

---

## Analytics & Tracking

### Google Analytics

**What's Tracked:**
- Page views
- User sessions
- Conversion events
- User demographics
- Traffic sources

**View Reports:**
1. Login to Google Analytics
2. Select property
3. View real-time data
4. Analyze reports

### UTM Tracking

**UTM Parameters:**
- `utm_source`: Traffic source (google, facebook, email)
- `utm_medium`: Marketing medium (cpc, banner, email)
- `utm_campaign`: Campaign name
- `utm_term`: Paid keywords
- `utm_content`: Ad variation

**Example URL:**
```
https://billing.fairewebhost.ca/register?utm_source=google&utm_medium=cpc&utm_campaign=summer2024
```

**Tracked Events:**
- User registration
- Service purchases
- Invoice payments
- Support tickets
- Login events

### Microsoft Clarity

**Features:**
- Session recordings
- Heatmaps
- User behavior analysis
- Rage clicks detection
- Dead clicks detection

**Access Clarity:**
1. Go to clarity.microsoft.com
2. Select project
3. View recordings and heatmaps

---

## API Documentation

### Authentication

**API Token:**
1. Login to account
2. Go to Account Settings
3. Click "API Access"
4. Generate API token
5. Use token in requests

**Header:**
```
Authorization: Bearer YOUR_API_TOKEN
```

### Endpoints

**Get User Info:**
```
GET /api/user
```

**Get Services:**
```
GET /api/services
```

**Get Invoices:**
```
GET /api/invoices
```

**Response Format:**
```json
{
  "status": "success",
  "data": { ... }
}
```

### Webhooks

**PayPal Webhook:**
```
POST /api/webhooks/paypal
```

**Stripe Webhook:**
```
POST /api/webhooks/stripe
```

---

## Troubleshooting

### Cannot Login

**Solutions:**
1. Verify email and password
2. Check Caps Lock
3. Clear browser cache
4. Try password reset
5. Try different browser
6. Contact support

### Google OAuth Not Working

**Solutions:**
1. Clear browser cookies
2. Disable ad blockers
3. Check popup blockers
4. Try incognito mode
5. Verify Google account is active

### Invoice Payment Failed

**Solutions:**
1. Check payment method details
2. Verify sufficient funds
3. Try different payment method
4. Contact your bank
5. Contact support

### Service Not Provisioned

**Solutions:**
1. Check order status
2. Verify payment completed
3. Wait 15-30 minutes
4. Check email for updates
5. Contact support

### Email Not Received

**Solutions:**
1. Check spam folder
2. Verify email address
3. Add to safe senders
4. Check email filters
5. Request resend

### cPanel Access Issues

**Solutions:**
1. Verify service is active
2. Check suspension status
3. Clear browser cache
4. Try direct cPanel URL
5. Reset cPanel password

---

## Contact Support

### Support Channels

**Email:** support@fairewebhost.ca
**Phone:** 1-800-XXX-XXXX
**Live Chat:** Available in client portal
**Support Tickets:** Recommended for technical issues

### Support Hours

- Monday - Friday: 9 AM - 6 PM EST
- Saturday: 10 AM - 4 PM EST
- Sunday: Closed
- Emergency support: 24/7 for critical issues

### Before Contacting Support

Please have ready:
1. Your account email
2. Service/domain name
3. Error messages
4. Screenshots (if applicable)
5. Steps to reproduce issue

---

## Best Practices

### Security

1. Use strong passwords (12+ characters)
2. Enable two-factor authentication
3. Don't share login credentials
4. Logout after use on shared computers
5. Keep contact information updated
6. Review account activity regularly

### Billing

1. Keep payment methods updated
2. Enable auto-pay for convenience
3. Review invoices promptly
4. Pay before due date
5. Keep receipts for records
6. Set up billing reminders

### Service Management

1. Renew domains before expiry
2. Monitor resource usage
3. Keep backups of important data
4. Update contact information
5. Review service needs regularly
6. Upgrade when needed

---

## Glossary

**cPanel:** Web hosting control panel
**Domain:** Your website address (e.g., example.com)
**Hosting:** Server space for your website
**Nameserver:** Directs domain to hosting server
**SSL:** Security certificate for HTTPS
**Bandwidth:** Data transfer allowance
**Disk Space:** Storage space for files
**Database:** Storage for dynamic content
**FTP:** File transfer protocol
**DNS:** Domain name system
**WHM:** Web Host Manager (server admin)

---

## Additional Resources

### Video Tutorials

Coming soon at: https://tutorials.fairewebhost.ca

### Knowledge Base

Visit: https://kb.fairewebhost.ca

### Community Forum

Join: https://community.fairewebhost.ca

### Blog

Read: https://blog.fairewebhost.ca

---

## Feedback

We value your feedback! Please let us know how we can improve:
- Email: feedback@fairewebhost.ca
- Feedback form in client portal
- Annual satisfaction survey

---

**Last Updated:** January 2026
**Version:** 1.0.0

For the most up-to-date documentation, visit: https://docs.fairewebhost.ca