# Fair E Web Host - Billing Panel System

A complete, production-ready billing and control panel system for Fair E Web Host built with custom MVC framework.

## Features

- **Custom MVC Framework** - Built from scratch with modern PHP 8.1+
- **Google OAuth 2.0** - Seamless authentication with Google
- **Analytics Integration** - Google Analytics, Google Tag Manager, Microsoft Clarity
- **UTM Tracking** - Complete campaign tracking system
- **Google AdSense** - Monetization ready
- **Security** - CSRF protection, rate limiting, secure sessions
- **Email System** - PHPMailer integration
- **Payment Gateways** - PayPal and Stripe ready
- **WHM/cPanel Integration** - Automated hosting provisioning
- **Domain Management** - ResellerClub API integration

## Requirements

- PHP 8.1 or higher
- MySQL 5.7 or higher
- Composer
- Apache/Nginx with mod_rewrite
- SSL Certificate (for production)

## Installation

### Step 1: Install Dependencies

```bash
cd fairpanel
composer install
```

### Step 2: Configure Environment

```bash
cp .env.example .env
```

Edit `.env` file with your configuration.

### Step 3: Set Permissions

```bash
chmod -R 755 fairpanel
chmod -R 777 fairpanel/storage
chmod -R 777 fairpanel/public/uploads
```

### Step 4: Import Database

```bash
mysql -u faireweb_billing_adm -p faireweb_billing26 < database/schema.sql
```

### Step 5: Access Installation

Visit: `https://billing.fairewebhost.ca`

Default admin credentials:
- Email: admin@fairewebhost.ca
- Password: Admin@123

**IMPORTANT: Change the default password immediately after first login!**

## Documentation

See INSTALLATION.md for detailed installation guide.
See HELP.md for user documentation.

## Support

For support, email: support@fairewebhost.ca

## License

Proprietary - Fair E Web Host

## Version

1.0.0 - Production Ready (2026 Standards)