<?php

namespace App\Controllers\Client;

use Core\Controller;

class DomainController extends Controller
{
    public function index(): void
    {
        $user = $this->getAuthUser();
        
        $domains = $this->database->table('domains')
            ->where('user_id', $user['id'])
            ->orderBy('created_at', 'DESC')
            ->get();
        
        $this->view('client.domains.index', [
            'domains' => $domains,
        ]);
    }

    public function show(int $id): void
    {
        $user = $this->getAuthUser();
        
        $domain = $this->database->table('domains')
            ->where('id', $id)
            ->where('user_id', $user['id'])
            ->first();
        
        if (!$domain) {
            $this->response->setStatusCode(404);
            $this->view('errors.404');
            return;
        }
        
        $this->view('client.domains.show', [
            'domain' => $domain,
        ]);
    }
}