<?php

namespace App\Controllers\Client;

use Core\Controller;

class ServiceController extends Controller
{
    public function index(): void
    {
        $user = $this->getAuthUser();
        
        $services = $this->database->table('hosting_accounts')
            ->where('user_id', $user['id'])
            ->orderBy('created_at', 'DESC')
            ->get();
        
        $this->view('client.services.index', [
            'services' => $services,
        ]);
    }

    public function show(int $id): void
    {
        $user = $this->getAuthUser();
        
        $service = $this->database->table('hosting_accounts')
            ->where('id', $id)
            ->where('user_id', $user['id'])
            ->first();
        
        if (!$service) {
            $this->response->setStatusCode(404);
            $this->view('errors.404');
            return;
        }
        
        // Get server info
        $server = null;
        if ($service['server_id']) {
            $server = $this->database->table('servers')
                ->where('id', $service['server_id'])
                ->first();
        }
        
        // Get related invoices
        $invoices = $this->database->table('invoices')
            ->where('user_id', $user['id'])
            ->orderBy('created_at', 'DESC')
            ->limit(5)
            ->get();
        
        $this->view('client.services.show', [
            'service' => $service,
            'server' => $server,
            'invoices' => $invoices,
        ]);
    }
}