<?php

namespace App\Models;

use Core\Model;

class Server extends Model
{
    protected string $table = 'servers';
    protected string $primaryKey = 'id';
    
    protected array $fillable = [
        'name',
        'hostname',
        'ip_address',
        'type',
        'status',
        'max_accounts',
        'current_accounts',
        'nameserver1',
        'nameserver2',
        'notes',
    ];
    
    protected array $casts = [
        'id' => 'int',
        'max_accounts' => 'int',
        'current_accounts' => 'int',
    ];
    
    protected bool $timestamps = true;

    public function accounts(): array
    {
        return $this->db->table('hosting_accounts')
            ->where('server_id', $this->id ?? 0)
            ->get();
    }

    public function isActive(): bool
    {
        $server = $this->find($this->id ?? 0);
        return $server && $server['status'] === 'active';
    }

    public function isFull(): bool
    {
        $server = $this->find($this->id ?? 0);
        if (!$server || !$server['max_accounts']) {
            return false;
        }
        
        return $server['current_accounts'] >= $server['max_accounts'];
    }

    public function getUsagePercentage(): float
    {
        $server = $this->find($this->id ?? 0);
        if (!$server || !$server['max_accounts']) {
            return 0;
        }
        
        return ($server['current_accounts'] / $server['max_accounts']) * 100;
    }

    public function incrementAccounts(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        $server = $this->find($this->id);
        if (!$server) {
            return false;
        }
        
        return $this->update($this->id, [
            'current_accounts' => $server['current_accounts'] + 1,
        ]) > 0;
    }

    public function decrementAccounts(): bool
    {
        if (!$this->id) {
            return false;
        }
        
        $server = $this->find($this->id);
        if (!$server || $server['current_accounts'] <= 0) {
            return false;
        }
        
        return $this->update($this->id, [
            'current_accounts' => $server['current_accounts'] - 1,
        ]) > 0;
    }
}