<?php
$pageTitle = 'My Invoices';
require __DIR__ . '/../layouts/header.php';
?>

<div class="py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>My Invoices</h2>
        <div>
            <a href="/client/invoices?status=all" class="btn btn-sm btn-outline-primary <?= $status === 'all' ? 'active' : '' ?>">All</a>
            <a href="/client/invoices?status=unpaid" class="btn btn-sm btn-outline-warning <?= $status === 'unpaid' ? 'active' : '' ?>">Unpaid</a>
            <a href="/client/invoices?status=paid" class="btn btn-sm btn-outline-success <?= $status === 'paid' ? 'active' : '' ?>">Paid</a>
        </div>
    </div>

    <?php if (empty($invoices)): ?>
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-file-invoice fa-4x text-muted mb-3"></i>
                <h4>No Invoices</h4>
                <p class="text-muted">You don't have any invoices yet.</p>
            </div>
        </div>
    <?php else: ?>
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Invoice #</th>
                                <th>Date</th>
                                <th>Due Date</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($invoices as $invoice): ?>
                            <tr>
                                <td><a href="/client/invoices/<?= $invoice['id'] ?>"><?= e($invoice['invoice_number']) ?></a></td>
                                <td><?= date_format_custom($invoice['created_at'], 'M d, Y') ?></td>
                                <td><?= date_format_custom($invoice['due_date'], 'M d, Y') ?></td>
                                <td>$<?= number_format($invoice['amount'], 2) ?></td>
                                <td>
                                    <span class="badge bg-<?= $invoice['status'] === 'paid' ? 'success' : 'warning' ?>">
                                        <?= ucfirst($invoice['status']) ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="/client/invoices/<?= $invoice['id'] ?>" class="btn btn-sm btn-primary">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                    <?php if ($invoice['status'] === 'unpaid'): ?>
                                    <a href="/client/invoices/<?= $invoice['id'] ?>" class="btn btn-sm btn-success">
                                        <i class="fas fa-credit-card"></i> Pay Now
                                    </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>