<?php
$pageTitle = 'My Services';
require __DIR__ . '/../layouts/header.php';
?>

<div class="py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>My Services</h2>
    </div>

    <?php if (empty($services)): ?>
        <div class="card">
            <div class="card-body text-center py-5">
                <i class="fas fa-server fa-4x text-muted mb-3"></i>
                <h4>No Services Yet</h4>
                <p class="text-muted">You don't have any active services.</p>
                <a href="/order" class="btn btn-primary">Order New Service</a>
            </div>
        </div>
    <?php else: ?>
        <div class="row">
            <?php foreach ($services as $service): ?>
            <div class="col-md-6 col-lg-4 mb-4">
                <div class="card h-100">
                    <div class="card-header bg-<?= $service['status'] === 'active' ? 'success' : 'warning' ?> text-white">
                        <h5 class="mb-0"><?= e($service['domain']) ?></h5>
                    </div>
                    <div class="card-body">
                        <p><strong>Status:</strong> 
                            <span class="badge bg-<?= $service['status'] === 'active' ? 'success' : 'warning' ?>">
                                <?= ucfirst($service['status']) ?>
                            </span>
                        </p>
                        <p><strong>Billing Cycle:</strong> <?= ucfirst($service['billing_cycle']) ?></p>
                        <p><strong>Next Due:</strong> <?= date_format_custom($service['next_due_date'], 'M d, Y') ?></p>
                        <p><strong>Price:</strong> $<?= number_format($service['price'], 2) ?></p>
                        
                        <hr>
                        
                        <div class="d-grid gap-2">
                            <a href="/client/services/<?= $service['id'] ?>" class="btn btn-primary btn-sm">
                                <i class="fas fa-eye"></i> View Details
                            </a>
                            <?php if ($service['status'] === 'active' && $service['cpanel_username']): ?>
                            <a href="https://<?= e($service['domain']) ?>:2083" target="_blank" class="btn btn-success btn-sm">
                                <i class="fas fa-external-link-alt"></i> Login to cPanel
                            </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    <?php endif; ?>
</div>

<?php require __DIR__ . '/../layouts/footer.php'; ?>